<?php

require_once __DIR__ . '/../class/JWT.php';

function jwtMiddleware($request, $response, $next)
{
    $headers = $request->getHeader('Authorization');
    $token = isset($headers[0]) ? $headers[0] : null;
 
    if (strpos($token, 'Bearer ') === 0) {
        // Extraer el token real sin el prefijo "Bearer "
        $token = substr($token, 7);
    } else {
        return $response->withJson(['error' => 'Token no proporcionado o formato inválido'], 401);
    }

    if (!$token) {
        return $response->withJson(['error' => 'Token no proporcionado'], 401);
    }

    $payload = JWT::verify($token);
    if (!$payload) {
        return $response->withJson(['error' => 'Token inválido o expirado'], 401);
    }

    $request = $request->withAttribute('jwt_payload', $payload);
    $response = $next($request, $response);

    return $response;
}
