<?php
require '../vendor/autoload.php';

class Plan
{
    private $plan_id;
    private $plan_nombre;
    private $plan_descripcion;
    private $plan_activo;
    private $plan_fec_creacion;

    public function __construct($plan_id = null)
    {
        global $db;

        try {
            if ($plan_id != null) {
                $result = $db->Execute("SELECT * FROM tbl_plan WHERE plan_id = ?", array($plan_id));
                if ($result && !$result->EOF) {
                    $fields = $result->fields;
                    $this->plan_id = $fields['plan_id'];
                    $this->plan_nombre = $fields['plan_nombre'];
                    $this->plan_descripcion = $fields['plan_descripcion'];
                    $this->plan_activo = $fields['plan_activo'];
                    $this->plan_fec_creacion = $fields['plan_fec_creacion'];
                }
            }
        } catch (Exception $e) {
            error_log("Error al inicializar el plan: " . $e->getMessage());
        }
    }

    // Getters and Setters
    public function getPlanId()
    {
        return $this->plan_id;
    }
    public function setPlanId($plan_id)
    {
        $this->plan_id = $plan_id;
    }

    public function getPlanNombre()
    {
        return $this->plan_nombre;
    }
    public function setPlanNombre($plan_nombre)
    {
        $this->plan_nombre = $plan_nombre;
    }

    public function getPlanDescripcion()
    {
        return $this->plan_descripcion;
    }
    public function setPlanDescripcion($plan_descripcion)
    {
        $this->plan_descripcion = $plan_descripcion;
    }

    public function getPlanActivo()
    {
        return $this->plan_activo;
    }
    public function setPlanActivo($plan_activo)
    {
        $this->plan_activo = $plan_activo;
    }

    public function getPlanFecCreacion()
    {
        return $this->plan_fec_creacion;
    }
    public function setPlanFecCreacion($plan_fec_creacion)
    {
        $this->plan_fec_creacion = $plan_fec_creacion;
    }
}
