<?php
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../vendor/adodb/adodb-php/adodb.inc.php';
require __DIR__ . '/../config/constants.php';

$config = require __DIR__ . '/../config/database.php';
ini_set('display_errors', '1');
// error_reporting(E_ALL);
global $db;
$db = NewADOConnection('mysql');
$db->Connect($config['host'], $config['username'], $config['password'], $config['database']);
$db->SetFetchMode(ADODB_FETCH_ASSOC); 
$db->Execute("SET NAMES 'utf8'");
$db->Execute("SET CHARACTER SET utf8"); 
//$db->debug = true; 
//$app = new \Slim\App();
//**Activo los errores */
$app = new \Slim\App(['settings' => ['displayErrorDetails' => true]]);
$app->add(function ($request, $response, $next) {
  $response = $next($request, $response);
  return $response
    ->withHeader('Access-Control-Allow-Origin', '*')
    ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization')
    ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});
// Se cargan las rutas desde la carpeta config
require __DIR__ . '/../config/routes.php';

function buildResponse(Response $response, array $data, int $httpCode = 200)
{
  $response = $response->withHeader('Content-Type', 'application/json')
    ->withStatus($httpCode);
  $response->getBody()->write(json_encode($data));
  return $response;
}

$app->run();
