<?php
class General {
    // Método estático para limpiar el parámetro
    public static function limpiarCodigo($parametro) {
        // Eliminar espacios en blanco al inicio y al final
        $parametro = trim($parametro);

        // Convertir caracteres especiales en entidades HTML
        $parametro = htmlspecialchars($parametro);

        // Escapar comillas simples y dobles
        $parametro = str_replace(["'", '"'], ["\'", '\"'], $parametro);

        // Reemplazos adicionales
        $reemplazos = [
            "select" => "seleccion",
            "update" => "actualizar",
            "create" => "crea",
            "drop" => "quita",
            "delete" => "elimina",
            "xp_" => "xpSP_",
            "where" => "donde",
            "group by" => "agrupado",
            "Trigger" => "gatilla",
            "declare" => "declara",
            "open" => "abrir",
            "while" => "mientras",
            "print" => "imprime",
            "execute" => "ejecuta",
            "commit" => "no_guarda",
            "varchar" => "vc",
            "exec" => "ejec",
            "char(" => "intento_inyeccion(",
            "ascii(" => "intento_inyeccion(",
            "script" => "cod",
            "-" => "&#45;",
            "[" => "&#91;",
            "]" => "&#93;",
            "%" => "&#37;",
            "Ã³" => "ó",
            "Ãº" => "ú",
            "Ã¡" => "á",
            "Ã©" => "é",
            "Ã" => "í",
            "í±" => "ñ"
        ];

        foreach ($reemplazos as $buscar => $reemplazar) {
            $parametro = str_ireplace($buscar, $reemplazar, $parametro);
        }

        return $parametro;
    }
}

?>