<?php
require '../vendor/autoload.php';
require_once __DIR__ . '/JWT.php';

class Usuario
{
    private $usu_id;
    private $perfil_id;
    private $inst_id;
    private $inst_nombre;
    private $inst_ciudad;
    private $inst_pais;
    private $usu_nombres;
    private $usu_apellidos;
    private $usu_email;
    private $usu_telefono;
    private $usu_username;
    private $usu_password;
    private $usu_activo;
    private $usu_fec_creacion;
    private $licencia_id;
    private $plan_id;

    public function __construct($usu_id = null)
    {
        global $db;

        try {
            if ($usu_id != null) {
                $result = $db->Execute("SELECT * FROM tbl_usuario WHERE usu_id = ?", array($usu_id));
                if ($result && !$result->EOF) {
                    $fields = $result->fields;
                    $this->usu_id = $fields['usu_id'];
                    $this->perfil_id = $fields['perfil_id'];
                    $this->inst_id = $fields['inst_id'];
                    $this->usu_nombres = $fields['usu_nombres'];
                    $this->usu_apellidos = $fields['usu_apellidos'];
                    $this->usu_email = $fields['usu_email'];
                    $this->usu_telefono = $fields['usu_telefono'];
                    $this->usu_username = $fields['usu_username'];
                    $this->usu_password = $fields['usu_password'];
                    $this->usu_activo = $fields['usu_activo'];
                    $this->usu_fec_creacion = $fields['usu_fec_creacion'];
                }
            }
        } catch (Exception $e) {
            error_log("Error al inicializar usuario: " . $e->getMessage());
        }
    }

    public function authenticate($username, $password)
    {
        global $db;
        $result = $db->Execute("SELECT u.usu_id,u.usu_nombres,u.usu_apellidos,u.usu_email,l.licencia_id,p.plan_id, i.inst_nombre, i.inst_pais, i.inst_ciudad FROM tbl_usuario u
                                INNER JOIN tbl_licencia_usuario lu ON lu.`usu_id` = u.`usu_id`
                                INNER JOIN tbl_licencia l ON l.`licencia_id` = lu.`licencia_id`
                                INNER JOIN tbl_plan p ON p.`plan_id` = l.`plan_id`
                                INNER JOIN tbl_institucion i ON i.inst_id = l.inst_id
                                WHERE usu_username = ? AND usu_password = ?", array($username, $password));

        if ($result && !$result->EOF) {
            $fields = $result->fields;
            $this->usu_id = $fields['usu_id'];
            $this->usu_nombres = $fields['usu_nombres'];
            $this->usu_apellidos = $fields['usu_apellidos'];
            $this->usu_email = $fields['usu_email'];
            $this->licencia_id = $fields['licencia_id'];
            $this->plan_id = $fields['plan_id'];
            $this->inst_nombre = $fields['inst_nombre'];
            $this->inst_ciudad = $fields['inst_ciudad'];
            $this->inst_pais = $fields['inst_pais'];
            return true;
        } else {
            return false;
        }
    }

    public function generateToken()
    {
        $payload = [
            "id" => $this->usu_id,
            "licencia" => $this->licencia_id,
            "plan" => $this->plan_id,
            "email" => $this->usu_email,
            "exp" => time() + (60 * 60) // Expira en 1 hora
        ];

        $token = JWT::create($payload);
        return $token;
    }


    // Getters and Setters
    public function getUsuId()
    {
        return $this->usu_id;
    }
    public function setUsuId($usu_id)
    {
        $this->usu_id = $usu_id;
    }

    public function getPerfilId()
    {
        return $this->perfil_id;
    }
    public function setPerfilId($perfil_id)
    {
        $this->perfil_id = $perfil_id;
    }

    public function getInstId()
    {
        return $this->inst_id;
    }
    public function getLicId()
    {
        return $this->licencia_id;
    }
    public function getInstitucionNombre()
    {
        return $this->inst_nombre;
    }
    public function getInstCiu()
    {
        return $this->inst_ciudad;
    }
    public function getInstPais()
    {
        return $this->inst_pais;
    }
    public function getPlanId()
    {
        return $this->plan_id;
    }
    public function setLicId($licencia_id)
    {
        $this->licencia_id = $licencia_id;
    }
    public function setPlantId($plan_id)
    {
        $this->plan_id = $plan_id;
    }

    public function setInstId($inst_id)
    {
        $this->inst_id = $inst_id;
    }

    public function getUsuNombres()
    {
        return $this->usu_nombres;
    }
    public function setUsuNombres($usu_nombres)
    {
        $this->usu_nombres = $usu_nombres;
    }

    public function getUsuApellidos()
    {
        return $this->usu_apellidos;
    }
    public function setUsuApellidos($usu_apellidos)
    {
        $this->usu_apellidos = $usu_apellidos;
    }

    public function getUsuEmail()
    {
        return $this->usu_email;
    }
    public function setUsuEmail($usu_email)
    {
        $this->usu_email = $usu_email;
    }

    public function getUsuTelefono()
    {
        return $this->usu_telefono;
    }
    public function setUsuTelefono($usu_telefono)
    {
        $this->usu_telefono = $usu_telefono;
    }

    public function getUsuUsername()
    {
        return $this->usu_username;
    }
    public function setUsuUsername($usu_username)
    {
        $this->usu_username = $usu_username;
    }

    public function getUsuPassword()
    {
        return $this->usu_password;
    }
    public function setUsuPassword($usu_password)
    {
        $this->usu_password = $usu_password;
    }

    public function getUsuActivo()
    {
        return $this->usu_activo;
    }
    public function setUsuActivo($usu_activo)
    {
        $this->usu_activo = $usu_activo;
    }

    public function getUsuFecCreacion()
    {
        return $this->usu_fec_creacion;
    }
    public function setUsuFecCreacion($usu_fec_creacion)
    {
        $this->usu_fec_creacion = $usu_fec_creacion;
    }
}
