<?php
require '../vendor/autoload.php';
require_once __DIR__ . '/JWT.php';

class Licencia
{
    private $licencia_id;
    private $plan_id;
    private $licencia_cantidad;
    private $licencia_api_key;
    private $licencia_fec_inicio;
    private $licencia_fec_termino;
    private $licencia_fec_creacion;
    private $licencia_activo;

    public function __construct($licencia_id = null)
    {
        global $db;

        try {
            if ($licencia_id != null) {
                $result = $db->Execute("SELECT * FROM tbl_licencia WHERE licencia_id = ?", array($licencia_id));
                if ($result && !$result->EOF) {
                    $fields = $result->fields;
                    $this->licencia_id = $fields['licencia_id'];
                    $this->plan_id = $fields['plan_id'];
                    $this->licencia_cantidad = $fields['licencia_cantidad'];
                    $this->licencia_api_key = $fields['licencia_api_key'];
                    $this->licencia_fec_inicio = $fields['licencia_fec_inicio'];
                    $this->licencia_fec_termino = $fields['licencia_fec_termino'];
                    $this->licencia_fec_creacion = $fields['licencia_fec_creacion'];
                    $this->licencia_activo = $fields['licencia_activo'];
                }
            }
        } catch (Exception $e) {
            error_log("Error al inicializar la licencia: " . $e->getMessage());
        }
    }
    

    // Getters and Setters
    public function getLicenciaId()
    {
        return $this->licencia_id;
    }
    public function setLicenciaId($licencia_id)
    {
        $this->licencia_id = $licencia_id;
    }

    public function getPlanId()
    {
        return $this->plan_id;
    }
    public function setPlanId($plan_id)
    {
        $this->plan_id = $plan_id;
    }

    public function getLicenciaCantidad()
    {
        return $this->licencia_cantidad;
    }
    public function setLicenciaCantidad($licencia_cantidad)
    {
        $this->licencia_cantidad = $licencia_cantidad;
    }

    public function getLicenciaApiKey()
    {
        return $this->licencia_api_key;
    }
    public function setLicenciaApiKey($licencia_api_key)
    {
        $this->licencia_api_key = $licencia_api_key;
    }

    public function getLicenciaFecInicio()
    {
        return $this->licencia_fec_inicio;
    }
    public function setLicenciaFecInicio($licencia_fec_inicio)
    {
        $this->licencia_fec_inicio = $licencia_fec_inicio;
    }
    public function getLicenciaFecTermino()
    {
        return $this->licencia_fec_termino;
    }
    public function setLicenciaFecTermino($licencia_fec_termino)
    {
        $this->licencia_fec_termino = $licencia_fec_termino;
    }

    public function getLicenciaFecCreacion()
    {
        return $this->licencia_fec_creacion;
    }
    public function setLicenciaFecCreacion($licencia_fec_creacion)
    {
        $this->licencia_fec_creacion = $licencia_fec_creacion;
    }

    public function getLicenciaActivo()
    {
        return $this->licencia_activo;
    }
    public function setLicenciaActivo($licencia_activo)
    {
        $this->licencia_activo = $licencia_activo;
    }
}
